/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips;

import club.sk1er.mods.scrollabletooltips.Config;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UScreen;
import net.minecraft.class_1735;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

public class TooltipScroller {
    private static final int TOOLTIP_PADDING_HORIZONTAL = 4;
    private static final int TOOLTIP_PADDING_VERTICAL = 1;
    private static final int SCREEN_MARGIN = 6;
    public static boolean needsReset;
    public static boolean allowScrolling;
    public static boolean tooltipNeedsScrolling;
    public static double scrollX;
    public static double scrollY;
    public static float zoomFactor;
    public static class_1735 currentSlot;

    public static void translateTooltip(Matrix3x2fStack matrixStack, int tooltipX, int tooltipY, int tooltipWidth, int tooltipHeight) {
        class_437 screen = UScreen.getCurrentScreen();
        assert (screen != null);
        int scaledTooltipHeight = (int)((float)tooltipHeight * zoomFactor);
        int scaledTooltipWidth = (int)((float)tooltipWidth * zoomFactor);
        if (needsReset) {
            scrollX = 0.0;
            allowScrolling = true;
            int totalPadding = 14;
            tooltipNeedsScrolling = Math.max(scaledTooltipHeight, tooltipHeight) + totalPadding > screen.field_22790 || Math.abs(tooltipY) + Math.max(scaledTooltipHeight, tooltipHeight) > screen.field_22790;
            scrollY = Config.startAtTop && tooltipNeedsScrolling ? (double)(6 - tooltipY) : 0.0;
            zoomFactor = 1.0f;
            needsReset = false;
        }
        if (!Config.masterToggle) {
            return;
        }
        if (allowScrolling) {
            int minY = screen.field_22790 - tooltipY - scaledTooltipHeight - 6;
            int maxY = 6 - tooltipY;
            if (minY <= maxY) {
                if (scrollY > (double)maxY) {
                    scrollY = maxY;
                } else if (scrollY < (double)minY) {
                    scrollY = minY;
                }
            } else {
                if (scrollY < (double)maxY) {
                    scrollY = maxY;
                }
                if (scrollY > (double)minY) {
                    scrollY = minY;
                }
            }
            int maxX = 4 - tooltipX;
            int minX = screen.field_22789 - tooltipX - scaledTooltipWidth - 4;
            if (minX <= maxX) {
                if (scrollX > (double)maxX) {
                    scrollX = maxX;
                } else if (scrollX < (double)minX) {
                    scrollX = minX;
                }
            } else {
                if (scrollX < (double)maxX) {
                    scrollX = maxX;
                }
                if (scrollX > (double)minX) {
                    scrollX = minX;
                }
            }
        }
        matrixStack.translate((float)scrollX, (float)scrollY);
        matrixStack.scale(zoomFactor, zoomFactor);
    }

    public static void resetScroll() {
        needsReset = true;
        allowScrolling = false;
    }

    public static boolean scroll(double delta) {
        if (UKeyboard.isCtrlKeyDown() && Config.zoom) {
            zoomFactor *= (float)(1.0 + 0.1 * Math.signum(delta));
            return true;
        }
        if (allowScrolling) {
            if (!tooltipNeedsScrolling) {
                if (!Config.enableScrollingSmallTooltips) {
                    return false;
                }
                if (!UKeyboard.isAltKeyDown()) {
                    return false;
                }
            }
            if (UKeyboard.isShiftKeyDown() && Config.horizontalScrolling) {
                scrollX += 10.0 * Math.signum(delta);
                return true;
            }
            if (Config.verticalScrolling) {
                scrollY += 10.0 * Math.signum(delta);
                return true;
            }
        }
        return false;
    }

    static {
        scrollX = 0.0;
        scrollY = 0.0;
        zoomFactor = 1.0f;
    }
}

